/*
 * Decompiled with CFR 0.152.
 */
package morfologik.fsa.builders;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import morfologik.fsa.FSA;
import morfologik.fsa.builders.ConstantArcSizeFSA;

public final class FSABuilder {
    private static final int MB = 0x100000;
    private static final int BUFFER_GROWTH_SIZE = 0x500000;
    private static final int MAX_LABELS = 256;
    public static final Comparator<byte[]> LEXICAL_ORDERING = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            return FSABuilder.compare(o1, 0, o1.length, o2, 0, o2.length);
        }
    };
    private final int bufferGrowthSize;
    private byte[] serialized = new byte[0];
    private int size;
    private int[] activePath = new int[0];
    private int activePathLen;
    private int[] nextArcOffset = new int[0];
    private int root;
    private int epsilon;
    private int[] hashSet = new int[2];
    private int hashSize = 0;
    private byte[] previous;
    private TreeMap<InfoEntry, Object> info;
    private int previousLength;
    private int serializationBufferReallocations;

    public FSABuilder() {
        this(0x500000);
    }

    public FSABuilder(int bufferGrowthSize) {
        this.bufferGrowthSize = Math.max(bufferGrowthSize, 1536);
        this.epsilon = this.allocateState(1);
        int n = this.epsilon + 0;
        this.serialized[n] = (byte)(this.serialized[n] | 1);
        this.expandActivePath(1);
        this.root = this.activePath[0];
    }

    public void add(byte[] sequence, int start2, int len) {
        int i;
        assert (this.serialized != null) : "Automaton already built.";
        assert (this.previous == null || len == 0 || FSABuilder.compare(this.previous, 0, this.previousLength, sequence, start2, len) <= 0) : "Input must be sorted: " + Arrays.toString(Arrays.copyOf(this.previous, this.previousLength)) + " >= " + Arrays.toString(Arrays.copyOfRange(sequence, start2, len));
        assert (this.setPrevious(sequence, start2, len));
        int commonPrefix = this.commonPrefix(sequence, start2, len);
        this.expandActivePath(len);
        for (i = this.activePathLen - 1; i > commonPrefix; --i) {
            int frozenState = this.freezeState(i);
            this.setArcTarget(this.nextArcOffset[i - 1] - 6, frozenState);
            this.nextArcOffset[i] = this.activePath[i];
        }
        int j = start2 + commonPrefix;
        for (i = commonPrefix + 1; i <= len; ++i) {
            int p = this.nextArcOffset[i - 1];
            this.serialized[p + 0] = (byte)(i == len ? 2 : 0);
            this.serialized[p + 1] = sequence[j++];
            this.setArcTarget(p, i == len ? 0 : this.activePath[i]);
            this.nextArcOffset[i - 1] = p + 6;
        }
        this.activePathLen = len;
    }

    public FSA complete() {
        this.add(new byte[0], 0, 0);
        if (this.nextArcOffset[0] - this.activePath[0] == 0) {
            this.setArcTarget(this.epsilon, 0);
        } else {
            this.root = this.freezeState(0);
            this.setArcTarget(this.epsilon, this.root);
        }
        this.info = new TreeMap();
        this.info.put(InfoEntry.SERIALIZATION_BUFFER_SIZE, this.serialized.length);
        this.info.put(InfoEntry.SERIALIZATION_BUFFER_REALLOCATIONS, this.serializationBufferReallocations);
        this.info.put(InfoEntry.CONSTANT_ARC_AUTOMATON_SIZE, this.size);
        this.info.put(InfoEntry.MAX_ACTIVE_PATH_LENGTH, this.activePath.length);
        this.info.put(InfoEntry.STATE_REGISTRY_TABLE_SLOTS, this.hashSet.length);
        this.info.put(InfoEntry.STATE_REGISTRY_SIZE, this.hashSize);
        this.info.put(InfoEntry.ESTIMATED_MEMORY_CONSUMPTION_MB, (double)(this.serialized.length + this.hashSet.length * 4) / 1048576.0);
        ConstantArcSizeFSA fsa = new ConstantArcSizeFSA(Arrays.copyOf(this.serialized, this.size), this.epsilon);
        this.serialized = null;
        this.hashSet = null;
        return fsa;
    }

    public static FSA build(byte[][] input) {
        FSABuilder builder = new FSABuilder();
        for (byte[] chs : input) {
            builder.add(chs, 0, chs.length);
        }
        return builder.complete();
    }

    public static FSA build(Iterable<byte[]> input) {
        FSABuilder builder = new FSABuilder();
        for (byte[] chs : input) {
            builder.add(chs, 0, chs.length);
        }
        return builder.complete();
    }

    public Map<InfoEntry, Object> getInfo() {
        return this.info;
    }

    private boolean isArcLast(int arc) {
        return (this.serialized[arc + 0] & 1) != 0;
    }

    private boolean isArcFinal(int arc) {
        return (this.serialized[arc + 0] & 2) != 0;
    }

    private byte getArcLabel(int arc) {
        return this.serialized[arc + 1];
    }

    private void setArcTarget(int arc, int state) {
        arc += 6;
        for (int i = 0; i < 4; ++i) {
            this.serialized[--arc] = (byte)state;
            state >>>= 8;
        }
    }

    private int getArcTarget(int arc) {
        return this.serialized[arc += 2] << 24 | (this.serialized[arc + 1] & 0xFF) << 16 | (this.serialized[arc + 2] & 0xFF) << 8 | this.serialized[arc + 3] & 0xFF;
    }

    private int commonPrefix(byte[] sequence, int start2, int len) {
        int lastArc;
        int i;
        int max = Math.min(len, this.activePathLen);
        for (i = 0; i < max && sequence[start2++] == this.getArcLabel(lastArc = this.nextArcOffset[i] - 6); ++i) {
        }
        return i;
    }

    private int freezeState(int activePathIndex) {
        int start2 = this.activePath[activePathIndex];
        int end = this.nextArcOffset[activePathIndex];
        int len = end - start2;
        int n = end - 6 + 0;
        this.serialized[n] = (byte)(this.serialized[n] | 1);
        int bucketMask = this.hashSet.length - 1;
        int slot = this.hash(start2, len) & bucketMask;
        int i = 0;
        while (true) {
            int state;
            if ((state = this.hashSet[slot]) == 0) {
                state = this.hashSet[slot] = this.serialize(activePathIndex);
                if (++this.hashSize > this.hashSet.length / 2) {
                    this.expandAndRehash();
                }
                return state;
            }
            if (this.equivalent(state, start2, len)) {
                return state;
            }
            slot = slot + ++i & bucketMask;
        }
    }

    private void expandAndRehash() {
        int[] newHashSet = new int[this.hashSet.length * 2];
        int bucketMask = newHashSet.length - 1;
        for (int j = 0; j < this.hashSet.length; ++j) {
            int state = this.hashSet[j];
            if (state <= 0) continue;
            int slot = this.hash(state, this.stateLength(state)) & bucketMask;
            int i = 0;
            while (newHashSet[slot] > 0) {
                slot = slot + ++i & bucketMask;
            }
            newHashSet[slot] = state;
        }
        this.hashSet = newHashSet;
    }

    private int stateLength(int state) {
        int arc = state;
        while (!this.isArcLast(arc)) {
            arc += 6;
        }
        return arc - state + 6;
    }

    private boolean equivalent(int start1, int start2, int len) {
        if (start1 + len > this.size || start2 + len > this.size) {
            return false;
        }
        while (len-- > 0) {
            if (this.serialized[start1++] == this.serialized[start2++]) continue;
            return false;
        }
        return true;
    }

    private int serialize(int activePathIndex) {
        this.expandBuffers();
        int newState = this.size;
        int start2 = this.activePath[activePathIndex];
        int len = this.nextArcOffset[activePathIndex] - start2;
        System.arraycopy(this.serialized, start2, this.serialized, newState, len);
        this.size += len;
        return newState;
    }

    private int hash(int start2, int byteCount) {
        assert (byteCount % 6 == 0) : "Not an arc multiply?";
        int h = 0;
        int arcs = byteCount / 6;
        while (--arcs >= 0) {
            h = 17 * h + this.getArcLabel(start2);
            h = 17 * h + this.getArcTarget(start2);
            if (this.isArcFinal(start2)) {
                h += 17;
            }
            start2 += 6;
        }
        return h;
    }

    private void expandActivePath(int size) {
        if (this.activePath.length < size) {
            int p = this.activePath.length;
            this.activePath = Arrays.copyOf(this.activePath, size);
            this.nextArcOffset = Arrays.copyOf(this.nextArcOffset, size);
            for (int i = p; i < size; ++i) {
                this.nextArcOffset[i] = this.activePath[i] = this.allocateState(256);
            }
        }
    }

    private void expandBuffers() {
        if (this.serialized.length < this.size + 1536) {
            this.serialized = Arrays.copyOf(this.serialized, this.serialized.length + this.bufferGrowthSize);
            ++this.serializationBufferReallocations;
        }
    }

    private int allocateState(int labels) {
        this.expandBuffers();
        int state = this.size;
        this.size += labels * 6;
        return state;
    }

    private boolean setPrevious(byte[] sequence, int start2, int length) {
        if (this.previous == null || this.previous.length < length) {
            this.previous = new byte[length];
        }
        System.arraycopy(sequence, start2, this.previous, 0, length);
        this.previousLength = length;
        return true;
    }

    private static int compare(byte[] s1, int start1, int lens1, byte[] s2, int start2, int lens2) {
        int max = Math.min(lens1, lens2);
        for (int i = 0; i < max; ++i) {
            byte c2;
            byte c1;
            if ((c1 = s1[start1++]) == (c2 = s2[start2++])) continue;
            return (c1 & 0xFF) - (c2 & 0xFF);
        }
        return lens1 - lens2;
    }

    public static enum InfoEntry {
        SERIALIZATION_BUFFER_SIZE("Serialization buffer size"),
        SERIALIZATION_BUFFER_REALLOCATIONS("Serialization buffer reallocs"),
        CONSTANT_ARC_AUTOMATON_SIZE("Constant arc FSA size"),
        MAX_ACTIVE_PATH_LENGTH("Max active path"),
        STATE_REGISTRY_TABLE_SLOTS("Registry hash slots"),
        STATE_REGISTRY_SIZE("Registry hash entries"),
        ESTIMATED_MEMORY_CONSUMPTION_MB("Estimated mem consumption (MB)");

        private final String stringified;

        private InfoEntry(String stringified) {
            this.stringified = stringified;
        }

        public String toString() {
            return this.stringified;
        }
    }
}

